# Copyright 2008 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import os
import pygame
from game import Game
from ai import Location

class BackToSkool(Game):
    def __init__(self, scale, iniFile):
        self.iniFile = iniFile
        self.background = 0
        Game.__init__(self, scale)

    def loadMutableImages(self, mode):
        self.mutables = self.mutables_ink = self.mutables_paper = None
        if mode == 0:
            self.mutables = self.getImage("mutables.png")
        else:
            self.mutables_ink = self.getImage("mutables_ink.png")
            self.mutables_paper = self.getImage("mutables_paper.png")

    def loadInventoryImage(self):
        self.inventory = self.getImage("inventory.png")

    def setDoorImages(self, doorId, shutTopLeft, size, coords):
        size = self.scaleCoords(size)
        shutTopLeft = self.scaleCoords(shutTopLeft)
        openTopLeft = (shutTopLeft[0] + size[0], shutTopLeft[1])
        if self.mutables:
            shutImages = (self.mutables.subsurface(shutTopLeft, size),)
            openImages = (self.mutables.subsurface(openTopLeft, size),)
        else:
            shutImageInk = self.mutables_ink.subsurface(shutTopLeft, size)
            shutImagePaper = self.mutables_paper.subsurface(shutTopLeft, size)
            shutImages = (shutImageInk, shutImagePaper)
            openImageInk = self.mutables_ink.subsurface(openTopLeft, size)
            openImagePaper = self.mutables_paper.subsurface(openTopLeft, size)
            openImages = (openImageInk, openImagePaper)
        self.skool.setDoorImages(doorId, openImages, shutImages, coords)
