#!/usr/bin/env python

# Copyright 2008 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import sys
import os
from optparse import OptionParser
import pygame
sys.path.append("pyskool")
from skooldaze import SkoolDaze
from backtoskool import BackToSkool

prog = os.path.basename(sys.argv[0].lower())
if prog.startswith('bts'):
    mode = 2
    name = 'Back to Skool'
    defaultIni = 'bak2skool.ini'
else:
    mode = 1
    name = 'Skool Daze'
    defaultIni = 'skool_daze.ini'
usage = "%prog [options]"
synopsis = "Start Pyskool in %s mode" % name
parser = OptionParser(usage=usage, version="0.0.2 (2008-09-23)", description=synopsis)
parser.add_option("-s", "--scale", dest="scale",
    help="scale graphics by this factor (1=original Speccy size)")
parser.add_option("-i", "--ini", dest="ini",
    help="use this ini file instead of %s" % defaultIni)
options, args = parser.parse_args()

scale = None
if options.scale:
    scale = int(options.scale) if options.scale.isdigit() else None
iniFile = options.ini or defaultIni
pygame.init()
game = BackToSkool(scale, iniFile) if mode == 2 else SkoolDaze(scale, iniFile)
game.play()
sys.exit(0)
