# Copyright 2008 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import pygame

class Keyboard:
    def __init__(self):
        self.pump()
        self.writing = False

    def pump(self):
        self.keyDownEvents = []
        self.keyUpEvents = []
        self.quit = False
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                self.quit = True
            if event.type == pygame.KEYDOWN:
                self.keyDownEvents.append(event)
            elif event.type == pygame.KEYUP:
                self.keyUpEvents.append(event)
        # It's important to collect pressed_keys AFTER clearing the event queue,
        # otherwise keys may appear to "stick"
        self.pressedKeys = list(pygame.key.get_pressed())

    def gotQuit(self):
        return self.quit

    def startWriting(self):
        self.writing = True

    def finishWriting(self):
        self.writing = False

    def getKeyDownEvents(self):
        return self.keyDownEvents

    def isPressed(self, key):
        if self.writing:
            return False
        if self.pressedKeys[key]:
            self.pressedKeys[key] = 0
            return True

    def wasPressed(self, key):
        if self.writing:
            return False
        for event in self.keyDownEvents:
            if event.key == key:
                self.keyDownEvents.remove(event)
                return True

    def pressed(self, key):
        return self.wasPressed(key) or self.isPressed(key)
