# Copyright 2008 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

from character import Character
from skool import Location
from ai import Fly

class Pellet(Character):
    def __init__(self, pelletId, tapId, pelletRange, hitZone):
        Character.__init__(self, pelletId, pelletId)
        self.tapId = tapId
        self.pelletRange = pelletRange
        self.hitZone = hitZone
        self.animatoryState = self.initialAS = 'FLY'
        self.initialDirection = -1
        self.initialLocation = Location((-3, 0))

    def isTimeToMove(self):
        self.actionDelay = (self.actionDelay + 1) % 3
        return self.actionDelay == 0

    def getVictim(self):
        """Returns whoever has been hit by this pellet, if anyone."""
        return self.cast.getVictimAt(self.x, self.y)

    def blocked(self):
        """Returns whether this pellet is blocked by a wall."""
        if self.barrier:
            if self.x > self.barrier.x:
                return self.x == self.barrier.x
            return self.x == self.barrier.x - 1
        return False

    def isAirborne(self):
        """Returns whether this pellet is airborne."""
        return self.x >= 0

    def getTapId(self, lessonId):
        return self.tapId

    def checkShields(self):
        return self.checkShieldsAt(self.x + 1, self.y + 1)

    def launch(self, x, y, direction):
        self.x = x
        self.y = y
        self.direction = direction
        self.actionDelay = 1
        self.addCommand(Fly(self.pelletRange, self.hitZone))
