# Copyright 2008 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import pygame
import os
import random

class Beeper:
    def __init__(self, soundsDir):
        self.soundsDir = soundsDir
        self.sounds = {}

    def getSound(self, soundFile):
        fname = os.path.join(*soundFile.split('/'))
        return pygame.mixer.Sound(os.path.join(self.soundsDir, fname))

    def addSound(self, soundId, soundFile):
        self.sounds[soundId] = self.getSound(soundFile)

    def playSound(self, soundId, wait=False):
        if self.sounds.has_key(soundId):
            channel = self.sounds[soundId].play()
            while wait and channel and channel.get_busy():
                pass

    def playTune(self):
        self.playSound('TUNE', True)

    def playAllShieldsTune(self):
        self.playSound('ALL_SHIELDS', True)

    def ringBell(self):
        self.playSound('BELL', True)

    def makeCatapultSound(self):
        self.playSound('CATAPULT')

    def makeWalkingSound(self, index):
        self.playSound('WALK%i' % (index % 4))

    def makeSittingSound(self):
        self.makeWalkingSound(random.randrange(4))

    def makeKnockedOutSound(self):
        self.playSound('KNOCKED_OUT')

    def makeShieldSound(self):
        self.playSound('SHIELD', True)

    def makeLinesSound(self, index):
        self.playSound('LINES%i' % index, True)
