# -*- coding: utf-8 -*-
# Copyright 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

from character import Character
from animatorystates import *
from skool import Location

class Plant(Character):
    def __init__(self, plant_id, tap_id, x, y):
        Character.__init__(self, plant_id, plant_id)
        self.tap_id = tap_id
        self.grow_x = x
        self.y = y
        self.animatory_state = self.initial_as = PLANT_GROWING
        self.direction = self.initial_direction = -1
        self.initial_location = Location((-3, y))
        self.height = 0
        self.growing = False

    def get_tap_id(self, lesson_id):
        return self.tap_id

    def grow(self):
        self.growing = True

    def head_coords(self):
        return (self.x, self.y - self.height - 1)

    def supports(self, character):
        return (character.x, character.y) == self.head_coords()

    def appear(self):
        self.x = self.grow_x
        self.animatory_state = self.initial_as
        self.cast.lift_anyone_at(*self.head_coords())
        self.height = 1

    def finish_growing(self):
        self.animatory_state = PLANT_GROWN
        self.cast.lift_anyone_at(*self.head_coords())
        self.height = 2

    def is_fully_grown(self):
        return self.height == 2

    def die(self):
        self.cast.drop_anyone_at(*self.head_coords())
        self.height = 0
        self.growing = False
        self.hide()
