# -*- coding: utf-8 -*-
# Copyright 2008-2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

class Flashable:
    def __init__(self, x, y, score, image=None, inverse_image=None):
        self.x = x
        self.y = y
        self.score = score
        self.image = image
        self.inverse_image = inverse_image
        self.flashing = False

    def get_score(self):
        return self.score // 10

    def is_flashing(self):
        return self.flashing

    def flash(self):
        self.flashing = True

    def unflash(self):
        self.flashing = False

    def get_images(self, inverse):
        if self.flashing:
            image = self.inverse_image if inverse else self.image
            return (self.x, self.y, image)
        return (0, 0, None)

class Shield(Flashable):
    pass

class Safe(Flashable):
    pass

class Cup:
    def __init__(self, cup_id, coords):
        self.cup_id = cup_id
        self.x, self.y = coords
        self.contents = None
        self.frogs = []

    def set_images(self, empty_images, water_images, sherry_images):
        self.empty_images = empty_images
        self.water_images = water_images
        self.sherry_images = sherry_images

    def is_empty(self):
        return not (self.contents or self.frogs)

    def fill(self, contents):
        self.contents = contents
        if contents == 'WATER':
            images = self.water_images
        elif contents == 'SHERRY':
            images = self.sherry_images
        else:
            images = self.empty_images
        return images, (self.x, self.y)

    def insert_frog(self, frog):
        self.frogs.append(frog)
        frog.insert_into_cup(self)

    def remove_frog(self, frog):
        if frog in self.frogs:
            self.frogs.remove(frog)

class Bike:
    def __init__(self, x, y):
        self.x = x
        self.y = y

    def set_images(self, unchained_images, chained_images):
        self.unchained_images = unchained_images
        self.chained_images = chained_images

    def unchain(self):
        return self.unchained_images, (self.x, self.y)

    def chain(self):
        return self.chained_images, (self.x, self.y)
