# -*- coding: utf-8 -*-
# Copyright 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

from character import Character
from animatorystates import *
from location import Location

class Water(Character):
    def __init__(self, water_id, tap_id):
        Character.__init__(self, water_id, water_id)
        self.tap_id = tap_id
        self.animatory_state = self.initial_as = WATER0
        self.initial_direction = -1
        self.initial_location = Location((-3, 0))
        self.liquid = None

    def get_tap_id(self, lesson_id):
        return self.tap_id

    def launch(self, x, y, direction, liquid):
        self.animatory_state = self.initial_as
        self.x = x
        self.y = y
        self.direction = direction
        self.liquid = liquid
        self.action_delay = 2

    def hit_cup(self):
        x = self.x - (1 if self.direction < 0 else -3)
        cup = self.skool.cup(x, self.y)
        if cup:
            self.skool.fill_cup(cup.cup_id, self.liquid)
            return True
        return False

    def hit_plant(self):
        plant_pot = self.skool.plant_pot(self.x, self.y)
        if plant_pot:
            self.cast.water_plant(plant_pot, self.liquid)
            return True
        return False

    def hit_floor(self):
        return self.floor is not None
