#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright 2008-2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import sys
import os.path
from optparse import OptionParser
pyskool_dir = os.path.abspath(os.path.dirname(__file__))
sys.path.insert(0, os.path.join(pyskool_dir, 'pyskool'))
from game import Game

VERSION = "0.2.2"
RELEASE_DATE = "2010-04-02"

prog = os.path.basename(sys.argv[0].lower())
if prog.startswith('bts'):
    name = 'Back to Skool'
    default_ini = 'back_to_skool.ini'
else:
    name = 'Skool Daze'
    default_ini = 'skool_daze.ini'
usage = "%prog [options]"
version = "%s (%s)" % (VERSION, RELEASE_DATE)
synopsis = "Start Pyskool in %s mode" % name
parser = OptionParser(usage=usage, version=version, description=synopsis)
parser.add_option("-s", "--scale", dest="scale",
    help="scale graphics by this factor (1=original Speccy size)")
parser.add_option("-i", "--ini", dest="ini",
    help="use this ini file instead of %s" % default_ini)
parser.add_option("-q", "--quick-start", dest="quick_start", action="store_true",
    help="start the game quickly")
parser.add_option("-c", "--cheat", dest="cheat", action="store_true",
    help="enable cheat keys")
options, args = parser.parse_args()

scale = int(options.scale) if options.scale and options.scale.isdigit() else None
ini_file = options.ini or os.path.join(pyskool_dir, default_ini)
icon_fname = os.path.join(pyskool_dir, 'icon.png')
game = Game(pyskool_dir, scale, ini_file, options.quick_start, VERSION, icon_fname)
game.play(options.cheat)
