# -*- coding: utf-8 -*-
# Copyright 2008-2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

class Scoreboard:
    def __init__(self, screen):
        self.screen = screen
        self.hiscore = 0
        self.reset()

    def reset(self):
        self.score = self.lines = 0

    def add_to_score(self, addend):
        self.score += addend
        self.screen.print_score(self.score)

    def add_lines(self, addend):
        self.lines = max(self.lines + addend, 0)
        self.screen.print_lines(self.lines)

    def reinitialise(self):
        if self.score > self.hiscore:
            self.hiscore = self.score
            self.screen.print_hi_score(self.hiscore)
        self.reset()
        self.screen.print_score(self.score)
        self.screen.print_lines(self.lines)

    def get_lines(self):
        return self.lines
