# -*- coding: utf-8 -*-
# Copyright 2008-2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import random

class Timetable:
    def __init__(self, lesson_length, lesson_start_time):
        self.index = -1
        self.lesson_id = None
        self.lessons = []
        self.lesson_details = {}
        self.counter = 0
        self.ticking = True
        self.lesson_length = lesson_length
        self.lesson_start_time = lesson_start_time
        self.special_playtimes = []

    def reinitialise(self):
        self.counter = 0
        self.ticking = True
        self.index = (self.index & 48) + 15

    def add_lesson(self, lesson_id):
        self.lessons.append(lesson_id)

    def add_lesson_details(self, lesson_id, hide_teacher, teacher_id, room_id):
        self.lesson_details[lesson_id] = (hide_teacher, teacher_id, room_id)

    def add_special_playtime(self, lesson_id):
        self.special_playtimes.append(lesson_id)

    def is_assembly(self):
        return self.lesson_id.startswith('Assembly')

    def is_playtime(self):
        return self.lesson_id.startswith('Playtime')

    def next_lesson(self):
        self.ticking = True
        self.counter = self.lesson_length
        self.index = (self.index + 1) % len(self.lessons)
        self.lesson_id = self.lessons[self.index]
        if self.is_playtime() and self.special_playtimes and random.randrange(8) < 3:
            self.lesson_id = random.choice(self.special_playtimes)

    def get_lesson_id(self):
        return self.lesson_id

    def hide_teacher(self):
        return self.lesson_details[self.get_lesson_id()][0]

    def get_teacher_id(self):
        return self.lesson_details[self.get_lesson_id()][1]

    def get_room_id(self):
        return self.lesson_details[self.get_lesson_id()][2]

    def tick(self):
        if self.ticking:
            self.counter -= 1
        return self.counter < 0

    def is_time(self, time):
        return self.counter + time < self.lesson_length

    def is_time_remaining(self, time):
        return self.counter < time

    def is_time_to_start_lesson(self):
        return self.is_time(self.lesson_start_time)

    def is_teaching_eric(self, character):
        return self.get_teacher_id() == character.character_id

    def up_a_year(self):
        self.counter = self.lesson_length // 2

    def stop(self):
        self.ticking = False

    def resume(self, ticks):
        self.counter = ticks
        self.ticking = True

    def rewind(self, ticks):
        self.counter += ticks
