# -*- coding: utf-8 -*-
# Copyright 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

from character import Character
from animatorystates import *
from location import Location

SPEED = 3
PEDAL_MOMENTUM = 2
MAX_MOMENTUM = 50

class Bike(Character):
    def __init__(self, bike_id, tap_id, initial_as, unchain_location):
        Character.__init__(self, bike_id, bike_id)
        self.tap_id = tap_id
        self.animatory_state = self.initial_as = initial_as
        self.direction = self.initial_direction = -1
        self.unchain_location = unchain_location
        self.x, self.y = -3, 0
        self.initial_location = Location((self.x, self.y))
        self.momentum = 0

    def get_tap_id(self, lesson_id):
        return self.tap_id

    def unchain(self):
        self.x, self.y = self.unchain_location

    def prepare(self):
        # Give ERIC some time to start pedalling before the bike falls over
        self.momentum = 3
        # The bike hides while ERIC is riding it
        self.hide()

    def pedal(self):
        self.momentum = min(self.momentum + PEDAL_MOMENTUM, MAX_MOMENTUM)

    def start_wheeling(self, rider):
        self.walk_delay = SPEED
        self.x, self.y, self.direction = rider.x, rider.y, rider.direction
        self.animatory_state = BIKE_UPRIGHT

    def wheel(self):
        self.walk_delay = SPEED
        self.momentum = max(self.momentum - 1, 0)
        if self.hit_barrier():
            self.momentum = 0
        else:
            self.x += self.direction

    def hit_barrier(self, barrier_id=None):
        # Check from a distance of 1 if travelling leftwards so that the bike
        # does not appear too close to the barrier if it hits it
        distance = 1 if self.direction < 0 else 0
        barrier =  self.skool.barrier(self, distance)
        if barrier_id:
            return barrier and barrier.barrier_id == barrier_id
        return barrier is not None

    def fall(self, rider=None):
        if rider:
            self.x, self.y, self.direction = rider.x, rider.y, rider.direction
        self.animatory_state = BIKE_ON_FLOOR
