# -*- coding: utf-8 -*-
# Copyright 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

from animatorystates import *
from character import Character
from location import Location
import items

class DeskLid(Character):
    def __init__(self, desk_lid_id, tap_id):
        Character.__init__(self, desk_lid_id, desk_lid_id)
        self.tap_id = tap_id
        self.animatory_state = self.initial_as = DESK_EMPTY
        self.direction = self.initial_direction = -1
        self.initial_location = Location((-3, 0))
        self.desk = None
        self.opener = None

    def get_tap_id(self, lesson_id):
        return self.tap_id

    def raise_lid(self, desk, character):
        if self.is_visible():
            return
        self.desk = desk
        self.x = desk.x - 1
        self.y = desk.y
        if desk.contents == items.WATER_PISTOL:
            self.animatory_state = DESK_WATER_PISTOL
        elif desk.contents == items.STINKBOMBS3:
            self.animatory_state = DESK_STINKBOMBS
        else:
            self.animatory_state = DESK_EMPTY
        self.opener = character

    def deliver_contents(self):
        self.opener.collect_desk_contents(self.desk)
