# -*- coding: utf-8 -*-
# Copyright 2008, 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

from character import Character
from animatorystates import *
from location import Location

# Coordinates of the pellet within its sprite (used for collision detection)
PELLET_X, PELLET_Y = 1, 1

class Pellet(Character):
    def __init__(self, pellet_id, tap_id, pellet_range, hit_zone):
        Character.__init__(self, pellet_id, pellet_id)
        self.tap_id = tap_id
        self.pellet_range = pellet_range
        self.hit_zone = hit_zone
        self.animatory_state = self.initial_as = FLY
        self.initial_direction = -1
        self.initial_location = Location((-3, 0))

    def impeded(self, bottom_y, top_y):
        return bottom_y >= self.y + 1 >= top_y

    def get_victim(self):
        """Return whoever has been hit by this pellet, if anyone."""
        return self.cast.get_pelletable(self.x, self.y)

    def get_tap_id(self, lesson_id):
        return self.tap_id

    def hit_shield(self):
        return self.check_shields_at(self.x + PELLET_X, self.y + PELLET_Y)

    def hit_cup(self):
        cup = self.skool.cup(self.x + PELLET_X, self.y + PELLET_Y)
        if cup and not cup.is_empty():
            self.cast.knock_cup(cup)
            return True
        return False

    def hit_conker(self):
        return self.cast.hit_conker(self)

    def launch(self, x, y, direction):
        self.x = x
        self.y = y
        self.direction = direction
        self.action_delay = 1
