# -*- coding: utf-8 -*-
# Copyright 2008-2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

ASSEMBLY_FINISHED = 'AssemblyFinished'
TIME_FOR_ASSEMBLY = 'TimeForAssembly'
SWOT_READY = 'SwotReady'

class Signals:
    def __init__(self):
        self.clear()

    def clear(self):
        self.signals = {}

    def is_raised(self, signal):
        return self.signals.get(signal, False)

    def signal(self, signal):
        self.signals[signal] = True

    def unsignal(self, signal):
        self.signals[signal] = False
