# -*- coding: utf-8 -*-
# Copyright 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

"""
The animatory state IDs recognised by Pyskool. They are used in the
`SpriteGroup` sections of the ini file.
"""

#: Character with arm raised (as if writing on a blackboard or opening a door).
ARM_UP = 'ARM_UP'
#: Character bending over (as if to catch a mouse).
BENDING_OVER = 'BENDING_OVER'
#: The bike lying on the floor.
BIKE_ON_FLOOR = 'BIKE_ON_FLOOR'
#: The bike upright.
BIKE_UPRIGHT = 'BIKE_UPRIGHT'
#: Character firing a catapult (phase 1).
CATAPULT0 = 'CATAPULT0'
#: Character firing a catapult (phase 2).
CATAPULT1 = 'CATAPULT1'
#: Conker.
CONKER = 'CONKER'
#: Desk lid and empty desk.
DESK_EMPTY = 'DESK_EMPTY'
#: Desk lid and stinkbombs.
DESK_STINKBOMBS = 'DESK_STINKBOMBS'
#: Desk lid and water pistol.
DESK_WATER_PISTOL = 'DESK_WATER_PISTOL'
#: Catapult pellet.
FLY = 'FLY'
#: Character throwing a punch (phase 1).
HITTING0 = 'HITTING0'
#: Character throwing a punch (phase 2).
HITTING1 = 'HITTING1'
#: Frog hopping (phase 1).
HOP1 = 'HOP1'
#: Frog hopping (phase 2).
HOP2 = 'HOP2'
#: Character kissing Eric.
KISSING_ERIC = 'KISSING_ERIC'
#: Character lying on back (as if knocked out).
KNOCKED_OUT = 'KNOCKED_OUT'
#: Character sitting on the floor (as when hit by a catapult pellet).
KNOCKED_OVER = 'KNOCKED_OVER'
#: Plant half-grown.
PLANT_GROWING = 'PLANT_GROWING'
#: Plant fully grown.
PLANT_GROWN = 'PLANT_GROWN'
#: Character riding a bike (phase 1).
RIDING_BIKE0 = 'RIDING_BIKE0'
#: Character riding a bike (phase 2).
RIDING_BIKE1 = 'RIDING_BIKE1'
#: Mouse running.
RUN = 'RUN'
#: Drop of sherry (spilt from a cup).
SHERRY_DROP = 'SHERRY_DROP'
#: Frog sitting still.
SIT = 'SIT'
#: Character sitting on a chair.
SITTING_ON_CHAIR = 'SITTING_ON_CHAIR'
#: Character sitting on the floor (as for assembly).
SITTING_ON_FLOOR = 'SITTING_ON_FLOOR'
#: Stinkbomb cloud.
STINKBOMB = 'STINKBOMB'
#: Character standing/walking (phase 1).
WALK0 = 'WALK0'
#: Character standing/walking (phase 2).
WALK1 = 'WALK1'
#: Character standing/walking (phase 3).
WALK2 = 'WALK2'
#: Character standing/walking (phase 4).
WALK3 = 'WALK3'
#: Drop of water (spilt from a cup).
WATER_DROP = 'WATER_DROP'
#: Water fired from a water pistol (phase 1).
WATER0 = 'WATER0'
#: Water fired from a water pistol (phase 2).
WATER1 = 'WATER1'
#: Water fired from a water pistol (phase 3).
WATER2 = 'WATER2'
#: Water fired from a water pistol (phase 4).
WATER3 = 'WATER3'
#: Water fired from a water pistol (phase 5+).
WATER4 = 'WATER4'
#: Character firing a water pistol.
WATERPISTOL = 'WATERPISTOL'
