# -*- coding: utf-8 -*-
# Copyright 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

"""
Lines message IDs recognised by Pyskool. The text of the lines messages
themselves are defined in the `LinesMessages` section of the ini file.
"""

#: Eric should be back in the boys' skool by now.
BACK_TO_SKOOL = 'BACK_TO_SKOOL'
#: Eric showed up for class while the swot was grassing on him for being
#: absent.
BE_PUNCTUAL = 'BE_PUNCTUAL'
#: Prefix for the lines message IDs used when Eric's teacher is fetching him.
COME_ALONG_PREFIX = 'COME_ALONG'
#: Eric should be in the dinner hall, assembly hall, or a particular classroom
#: by now.
GET_ALONG = 'GET_ALONG'
#: Eric is standing on a plant.
GET_OFF_PLANT = 'GET_OFF_PLANT'
#: Eric is somewhere he should never be (such as the head's study).
GET_OUT = 'GET_OUT'
#: Eric is sitting or lying on the floor.
GET_UP = 'GET_UP'
#: Somebody knocked a teacher over.
NEVER_AGAIN = 'NEVER_AGAIN'
#: Eric is riding the bike inside the boys' skool.
NO_BIKES = 'NO_BIKES'
#: Eric is firing his catapult.
NO_CATAPULTS = 'NO_CATAPULTS'
#: Eric is throwing a punch.
NO_HITTING = 'NO_HITTING'
#: Eric is jumping.
NO_JUMPING = 'NO_JUMPING'
#: Eric is sitting on the stairs.
NO_SITTING_ON_STAIRS = 'NO_SITTING_ON_STAIRS'
#: Eric dropped a stinkbomb.
NO_STINKBOMBS = 'NO_STINKBOMBS'
#: The swot told a tale.
NO_TALES = 'NO_TALES'
#: Eric is firing a water pistol.
NO_WATERPISTOLS = 'NO_WATERPISTOLS'
#: Eric is writing on a blackboard.
NO_WRITING = 'NO_WRITING'
#: Eric is standing up in class when he should be sitting down.
SIT_DOWN = 'SIT_DOWN'
#: Eric is sitting down facing the wrong way in assembly.
SIT_FACING_STAGE = 'SIT_FACING_STAGE'
#: Eric left the classroom and then returned while the swot was grassing on him
#: for being absent.
STAY_IN_CLASS = 'STAY_IN_CLASS'
