# -*- coding: utf-8 -*-
# Copyright 2008-2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

"""
Maintain the signals used by characters for coordination during a lesson.
"""

#: Signal raised by Mr Wacker when he has finished speaking in assembly.
ASSEMBLY_FINISHED = 'AssemblyFinished'
#: Signal raised when it's time for the kids to sit down for assembly.
TIME_FOR_ASSEMBLY = 'TimeForAssembly'
#: Signal raised by the swot when he sits down in a classroom at the start of a
#: lesson.
SWOT_READY = 'SwotReady'

class Signals:
    """Raises and lowers signals."""
    def __init__(self):
        self.clear()

    def clear(self):
        """Clear all signals. This is done at the beginning of each timetable
        period.
        """
        self.signals = {}

    def is_raised(self, signal):
        """Return whether a signal is raised.

        :param signal: The name of the signal to check.
        """
        return self.signals.get(signal, False)

    def signal(self, signal):
        """Raise a signal.

        :param signal: The name of the signal to raise.
        """
        self.signals[signal] = True

    def unsignal(self, signal):
        """Lower a signal.

        :param signal: The name of the signal to lower.
        """
        self.signals[signal] = False
