# -*- coding: utf-8 -*-
# Copyright 2008, 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import pygame
import os
import random

class Beeper:
    def __init__(self, sounds_dir):
        self.sounds_dir = sounds_dir
        self.sounds = {}

    def get_sound(self, sound_file):
        fname = os.path.join(*sound_file.split('/'))
        return pygame.mixer.Sound(os.path.join(self.sounds_dir, fname))

    def add_sound(self, sound_id, sound_file):
        self.sounds[sound_id] = self.get_sound(sound_file)

    def play_sound(self, sound_id, wait=False):
        if sound_id in self.sounds:
            channel = self.sounds[sound_id].play()
            while wait and channel and channel.get_busy():
                pass

    def play_tune(self):
        self.play_sound('TUNE', True)

    def play_all_shields_tune(self):
        self.play_sound('ALL_SHIELDS', True)

    def ring_bell(self):
        self.play_sound('BELL', True)

    def make_catapult_sound(self):
        self.play_sound('CATAPULT')

    def make_walking_sound(self, index):
        self.play_sound('WALK%i' % (index % 4))

    def make_sitting_sound(self):
        self.make_walking_sound(random.randrange(4))

    def make_knocked_out_sound(self):
        self.play_sound('KNOCKED_OUT')

    def make_shield_sound(self):
        self.play_sound('SHIELD', True)

    def make_lines_sound(self, index):
        self.play_sound('LINES%i' % index, True)

    def make_bingo_sound(self):
        self.play_sound('BINGO', True)

    def make_mouse_sound(self):
        self.play_sound('MOUSE', True)
