# -*- coding: utf-8 -*-
# Copyright 2008, 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import pygame

class Keyboard:
    def __init__(self):
        self.pump()
        self.writing = False

    def pump(self):
        self.key_down_events = []
        self.quit = False
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                self.quit = True
            elif event.type == pygame.KEYDOWN:
                self.key_down_events.append(event)
        # It's important to collect pressed_keys AFTER clearing the event queue,
        # otherwise keys may appear to "stick"
        self.pressed_keys = list(pygame.key.get_pressed())

    def got_quit(self):
        return self.quit

    def start_writing(self):
        self.writing = True

    def finish_writing(self):
        self.writing = False

    def is_pressed(self, key):
        if not self.writing and self.pressed_keys[key]:
            self.pressed_keys[key] = 0
            return True
        return False

    def was_pressed(self, key):
        if not self.writing:
            for event in self.key_down_events:
                if event.key == key:
                    self.key_down_events.remove(event)
                    return True
        return False

    def pressed(self, key):
        return self.was_pressed(key) or self.is_pressed(key)
