# -*- coding: utf-8 -*-

# Copyright 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

# Character IDs
CREAK = 'CREAK'
WITHIT = 'WITHIT'
ROCKITT = 'ROCKITT'
WACKER = 'WACKER'
TAKE = 'TAKE'
ALBERT = 'ALBERT'
TEARAWAY = 'TEARAWAY'
BULLY = 'BULLY'
SWOT = 'SWOT'
HERO = 'HERO'
HEROINE = 'HEROINE'

BOY01 = 'BOY01'
BOY02 = 'BOY02'
BOY03 = 'BOY03'
BOY04 = 'BOY04'
BOY05 = 'BOY05'
BOY06 = 'BOY06'
BOY07 = 'BOY07'
BOY08 = 'BOY08'
BOY09 = 'BOY09'
BOY10 = 'BOY10'
BOY11 = 'BOY11'

GIRL01 = 'GIRL01'
GIRL02 = 'GIRL02'
GIRL03 = 'GIRL03'
GIRL04 = 'GIRL04'
GIRL05 = 'GIRL05'
GIRL06 = 'GIRL06'
GIRL07 = 'GIRL07'

# Location marker
LOCATION_MARKER = 'Location:'

# Door IDs
DRINKS_CABINET = 'DrinksCabinet'
STOREROOM_DOOR = 'ScienceLabDoor'
SKOOL_DOOR = 'SkoolDoor'
SKOOL_GATE = 'SkoolGate'

# Back to Skool command list IDs
CL_BIKE = 'Bike'
CL_CONKER = 'Conker'
CL_DESK_LID = 'DeskLid'
CL_FROG = 'Frog'
CL_MOUSE = 'Mouse'
CL_PLANT = 'Plant'
CL_SHERRY_DROP = 'SherryDrop'
CL_STINKBOMB = 'Stinkbomb'
CL_WATER = 'Water'
CL_WATER_DROP = 'WaterDrop'
CL_EXPEL_ERIC_NOT_A_BIRD = 'ExpelEric:NotABird'

# Common command list IDs
CL_EXPEL_ERIC_TOO_MANY_LINES = 'ExpelEric:TooManyLines'
CL_PELLET = 'Pellet'

# Room IDs
READING_ROOM = 'ReadingRoom'
MAP_ROOM = 'MapRoom'
WHITE_ROOM = 'WhiteRoom'
EXAM_ROOM = 'ExamRoom'
DINNER_HALL = 'DinnerHall'
BLUE_ROOM = 'BlueRoom'
YELLOW_ROOM = 'YellowRoom'
SCIENCE_LAB = 'ScienceLab'
UPPER_ROOM = 'UpperRoom'
MIDDLE_ROOM = 'MiddleRoom'
ASSEMBLY_HALL = 'AssemblyHall'

# Names of unsupervised periods
REVISION_LIBRARY = 'REVISION LIBRARY'
PLAYTIME = 'PLAYTIME'

# Sprite groups
SG_ERIC = 'ERIC'
SG_BOY = 'BOY'
SG_SWOT = 'SWOT'
SG_BULLY = 'BULLY'
SG_TEARAWAY = 'TEARAWAY'
SG_WACKER = 'WACKER'
SG_ROCKITT = 'ROCKITT'
SG_WITHIT = 'WITHIT'
SG_CREAK = 'CREAK'
SG_PELLET = 'PELLET'
SG_TAKE = 'TAKE'
SG_GIRL = 'GIRL'
SG_ALBERT = 'ALBERT'
SG_HEROINE = 'HEROINE'
SG_MOUSE = 'MOUSE'
SG_FROG = 'FROG'
SG_WATER = 'WATER'
SG_STINKBOMB = 'STINKBOMB'
SG_DESK = 'DESK'
SG_BIKE = 'BIKE'
SG_PLANT = 'PLANT'
SG_WATER_DROP = 'WATER_DROP'
SG_SHERRY_DROP = 'SHERRY_DROP'
SG_CONKER = 'CONKER'

# Common walkabout locations
LOC_HEADS_STUDY_0 = 'HeadsStudy:0'
LOC_REVISION_LIBRARY_0 = 'RevisionLibrary:0'
LOC_REVISION_LIBRARY_1 = 'RevisionLibrary:1'

# Common other locations
LOC_HEADS_STUDY_WINDOW = 'HeadsStudy:Window'
LOC_REVISION_LIBRARY = 'RevisionLibrary'

# Skool Daze walkabout locations
LOC_BIG_WINDOW = 'BigWindow'
LOC_DINNER_HALL_0 = 'DinnerHall:0'
LOC_DINNER_HALL_1 = 'DinnerHall:1'
LOC_EXAM_ROOM_0 = 'ExamRoom:0'
LOC_EXAM_ROOM_1 = 'ExamRoom:1'
LOC_EXAM_ROOM_2 = 'ExamRoom:2'
LOC_EXAM_ROOM_3 = 'ExamRoom:3'
LOC_FIRE_ESCAPE_0 = 'FireEscape:0'
LOC_GYM = 'Gym'
LOC_MAP_ROOM_0 = 'MapRoom:0'
LOC_MAP_ROOM_1 = 'MapRoom:1'
LOC_MAP_ROOM_2 = 'MapRoom:2'
LOC_PEA_SHOOTER_RACE_0 = 'PeaShooterRace:0'
LOC_PEA_SHOOTER_RACE_1 = 'PeaShooterRace:1'
LOC_READING_ROOM_0 = 'ReadingRoom:0'
LOC_READING_ROOM_1 = 'ReadingRoom:1'
LOC_READING_ROOM_2 = 'ReadingRoom:2'
LOC_REVISION_LIBRARY_0 = 'RevisionLibrary:0'
LOC_REVISION_LIBRARY_1 = 'RevisionLibrary:1'
LOC_STAFF_ROOM_0 = 'StaffRoom:0'
LOC_WHITE_ROOM_0 = 'WhiteRoom:0'
LOC_WHITE_ROOM_1 = 'WhiteRoom:1'
LOC_WHITE_ROOM_2 = 'WhiteRoom:2'

# Skool Daze other locations
LOC_DINNER_HALL_FAR_END = 'DinnerHall:FarEnd'
LOC_DINNER_HALL_NEAR_END = 'DinnerHall:NearEnd'
LOC_EXAM_ROOM_BOARD_EDGE = 'ExamRoomBlackboard:Edge'
LOC_EXAM_ROOM_BOARD = 'ExamRoomBlackboard'
LOC_EXAM_ROOM_DOORWAY = 'ExamRoomDoorway'
LOC_FIRE_ESCAPE = 'FireEscape'
LOC_HEADS_STUDY_DESK = 'HeadsStudy:Desk'
LOC_MAP_ROOM_DOORWAY = 'MapRoomDoorway'
LOC_MAP_ROOM_MAP_EDGE = 'MapRoom:MapEdge'
LOC_MAP_ROOM_MAP = 'MapRoom:Map'
LOC_READING_ROOM_BOARD_EDGE = 'ReadingRoomBlackboard:Edge'
LOC_READING_ROOM_BOARD = 'ReadingRoomBlackboard'
LOC_READING_ROOM_DOORWAY = 'ReadingRoomDoorway'
LOC_READING_ROOM = 'ReadingRoom'
LOC_STAFF_ROOM = 'StaffRoom'
LOC_WHITE_ROOM_BOARD_EDGE = 'WhiteRoomBlackboard:Edge'
LOC_WHITE_ROOM_BOARD = 'WhiteRoomBlackboard'
LOC_WHITE_ROOM_DOORWAY = 'WhiteRoomDoorway'
LOC_WHITE_ROOM = 'WhiteRoom'

# Back to Skool walkabout locations
LOC_ASSEMBLY_HALL_0 = 'AssemblyHall:0'
LOC_ASSEMBLY_HALL_1 = 'AssemblyHall:1'
LOC_ASSEMBLY_HALL_2 = 'AssemblyHall:2'
LOC_BLUE_ROOM_0 = 'BlueRoom:0'
LOC_BLUE_ROOM_1 = 'BlueRoom:1'
LOC_BOYS_DINNER_HALL_0 = 'BoysDinnerHall:0'
LOC_BOYS_DINNER_HALL_1 = 'BoysDinnerHall:1'
LOC_BOYS_PLAYGROUND_0 = 'BoysPlayground:0'
LOC_GIRLS_DINNER_HALL = 'GirlsDinnerHall'
LOC_GIRLS_PLAYGROUND_0 = 'GirlsPlayground:0'
LOC_JUST_RIGHT_OF_TREE = 'JustRightOfTree'
LOC_KITCHEN = 'Kitchen'
LOC_MIDDLE_ROOM = 'MiddleRoom'
LOC_SCIENCE_LAB_0 = 'ScienceLab:0'
LOC_SCIENCE_LAB_1 = 'ScienceLab:1'
LOC_SCIENCE_LAB_2 = 'ScienceLab:2'
LOC_UPPER_ROOM = 'UpperRoom'
LOC_YELLOW_ROOM_0 = 'YellowRoom:0'
LOC_YELLOW_ROOM_1 = 'YellowRoom:1'

# Back to Skool other locations
LOC_ASSEMBLY_HALL_BACK = 'AssemblyHall:Back'
LOC_ASSEMBLY_HALL_STAGE_EDGE = 'AssemblyHallStage:Edge'
LOC_ASSEMBLY_HALL_STAGE_MIDDLE = 'AssemblyHallStage:Middle'
LOC_ASSEMBLY_HALL_WAY_BACK = 'AssemblyHall:WayBack'
LOC_BLUE_ROOM_BOARD_EDGE = 'BlueRoomBlackboard:Edge'
LOC_BLUE_ROOM_BOARD_MIDDLE = 'BlueRoomBlackboard:Middle'
LOC_BLUE_ROOM_DOORWAY = 'BlueRoomDoorway'
LOC_BOYS_DINNER_HALL_END_1 = 'BoysDinnerHall:End1'
LOC_BOYS_DINNER_HALL_END_2 = 'BoysDinnerHall:End2'
LOC_BOYS_PLAYGROUND_MIDDLE = 'BoysPlayground:Middle'
LOC_BOYS_SKOOL_DOOR = 'BoysSkoolDoor'
LOC_CLOAK_ROOM = 'CloakRoom'
LOC_DRINKS_CABINET = 'DrinksCabinet'
LOC_GIRLS_MIDDLE_FLOOR_WINDOW = 'GirlsMiddleFloorWindow'
LOC_JUST_OUTSIDE_TOILETS = 'JustOutsideToilets'
LOC_MIDDLE_ROOM_BOARD_EDGE = 'MiddleRoomBlackboard:Edge'
LOC_MIDDLE_ROOM_BOARD_MIDDLE = 'MiddleRoomBlackboard:Middle'
LOC_MIDDLE_ROOM_DOORWAY = 'MiddleRoomDoorway'
LOC_SCIENCE_LAB_BOARD_EDGE = 'ScienceLabBlackboard:Edge'
LOC_SCIENCE_LAB_BOARD_MIDDLE = 'ScienceLabBlackboard:Middle'
LOC_SCIENCE_LAB_DOORWAY = 'ScienceLabDoorway'
LOC_SKOOL_GATE_TO_OPEN = 'SkoolGate:ToOpen'
LOC_SKOOL_GATE_TO_SHUT = 'SkoolGate:ToShut'
LOC_TAKES_STUDY_DOORWAY = 'TakesStudyDoorway'
LOC_TOP_OF_STAIRS_DOWN_TO_STAGE = 'TopOfStairsDownToStage'
LOC_UPPER_ROOM_BOARD_EDGE = 'UpperRoomBlackboard:Edge'
LOC_UPPER_ROOM_BOARD_MIDDLE = 'UpperRoomBlackboard:Middle'
LOC_UPPER_ROOM_DOORWAY = 'UpperRoomDoorway'
LOC_YELLOW_ROOM_BOARD_EDGE = 'YellowRoomBlackboard:Edge'
LOC_YELLOW_ROOM_BOARD_MIDDLE = 'YellowRoomBlackboard:Middle'
LOC_YELLOW_ROOM_DOORWAY = 'YellowRoomDoorway'

# Lesson ID prefixes
PLAYTIME_PREFIX = 'Playtime'
ASSEMBLY_PREFIX = 'Assembly'

# Common lesson IDs
LSN_DINNER_WITHIT = 'Dinner-Withit'
LSN_DINNER_WACKER = 'Dinner-Wacker'
LSN_PLAYTIME_1 = '%s-1' % PLAYTIME_PREFIX
LSN_PLAYTIME_2 = '%s-2' % PLAYTIME_PREFIX
LSN_PLAYTIME_3 = '%s-3' % PLAYTIME_PREFIX
LSN_PLAYTIME_4 = '%s-4' % PLAYTIME_PREFIX
LSN_PLAYTIME_5 = '%s-5' % PLAYTIME_PREFIX
LSN_REVISION_LIBRARY_1 = 'RevisionLibrary-1'
LSN_REVISION_LIBRARY_2 = 'RevisionLibrary-2'

# Skool Daze lesson IDs
LSN_CREAK_READING_ROOM_1 = 'Creak-ReadingRoom-1'
LSN_CREAK_READING_ROOM_2 = 'Creak-ReadingRoom-2'
LSN_CREAK_WHITE_ROOM = 'Creak-WhiteRoom'
LSN_PLAYTIME_6 = '%s-6' % PLAYTIME_PREFIX
LSN_PLAYTIME_7 = '%s-7' % PLAYTIME_PREFIX
LSN_PLAYTIME_8 = '%s-8' % PLAYTIME_PREFIX
LSN_PLAYTIME_MUMPS = '%s-Mumps' % PLAYTIME_PREFIX
LSN_PLAYTIME_PEA_SHOOTER = '%s-HiddenPeaShooter' % PLAYTIME_PREFIX
LSN_PLAYTIME_STAMPEDE_1 = '%s-Stampede-1' % PLAYTIME_PREFIX
LSN_PLAYTIME_STAMPEDE_2 = '%s-Stampede-2' % PLAYTIME_PREFIX
LSN_PLAYTIME_SWOT_GRASS = '%s-SwotGrass' % PLAYTIME_PREFIX
LSN_REVISION_LIBRARY_3 = 'RevisionLibrary-3'
LSN_ROCKITT_EXAM_ROOM = 'Rockitt-ExamRoom'
LSN_ROCKITT_READING_ROOM = 'Rockitt-ReadingRoom'
LSN_ROCKITT_WHITE_ROOM_1 = 'Rockitt-WhiteRoom-1'
LSN_ROCKITT_WHITE_ROOM_2 = 'Rockitt-WhiteRoom-2'
LSN_TAKE_EXAM_ROOM = 'Take-ExamRoom'
LSN_TAKE_MAP_ROOM = 'Take-MapRoom'
LSN_TAKE_READING_ROOM = 'Take-ReadingRoom'
LSN_TAKE_WHITE_ROOM = 'Take-WhiteRoom'
LSN_WACKER_EXAM_ROOM = 'Wacker-ExamRoom'
LSN_WACKER_MAP_ROOM = 'Wacker-MapRoom'
LSN_WACKER_READING_ROOM = 'Wacker-ReadingRoom'
LSN_WACKER_WHITE_ROOM = 'Wacker-WhiteRoom'
LSN_WITHIT_MAP_ROOM_1 = 'Withit-MapRoom-1'
LSN_WITHIT_MAP_ROOM_2 = 'Withit-MapRoom-2'
LSN_WITHIT_WHITE_ROOM = 'Withit-WhiteRoom'

# Back to Skool lesson IDs
LSN_ASSEMBLY = ASSEMBLY_PREFIX
LSN_CREAK_BLUE_ROOM_1 = 'Creak-BlueRoom-1'
LSN_CREAK_BLUE_ROOM_2 = 'Creak-BlueRoom-2'
LSN_CREAK_YELLOW_ROOM_1 = 'Creak-YellowRoom-1'
LSN_CREAK_YELLOW_ROOM_2 = 'Creak-YellowRoom-2'
LSN_PLAYTIME_BOYS_SKOOL_STAMPEDE = '%s-BoysSkoolStampede' % PLAYTIME_PREFIX
LSN_PLAYTIME_GIRLS_SKOOL_STAMPEDE = '%s-GirlsSkoolStampede' % PLAYTIME_PREFIX
LSN_ROCKITT_SCIENCE_LAB_1 = 'Rockitt-ScienceLab-1'
LSN_ROCKITT_SCIENCE_LAB_2 = 'Rockitt-ScienceLab-2'
LSN_ROCKITT_SCIENCE_LAB_3 = 'Rockitt-ScienceLab-3'
LSN_WITHIT_BLUE_ROOM_1 = 'Withit-BlueRoom-1'
LSN_WITHIT_BLUE_ROOM_2 = 'Withit-BlueRoom-2'
LSN_WITHIT_SCIENCE_LAB_1 = 'Withit-ScienceLab-1'
LSN_WITHIT_SCIENCE_LAB_2 = 'Withit-ScienceLab-2'
LSN_WITHIT_YELLOW_ROOM_1 = 'Withit-YellowRoom-1'
LSN_WITHIT_YELLOW_ROOM_2 = 'Withit-YellowRoom-2'
