#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright 2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import sys
import os
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..', 'pyskool'))
sys.path.insert(0, os.path.join(os.path.dirname(__file__), 'lib'))
from sdini import SDIniMaker
from btsini import BTSIniMaker

SKOOL_DAZE = 'sd'
BACK_TO_SKOOL = 'bts'

def parse_options(options):
    verbose = True
    custom = 0
    i = 0
    while i < len(options):
        option = options[i]
        if option == '-c':
            custom = int(options[i + 1])
            i += 1
        elif option == '-q':
            verbose = False
        i += 1
    return verbose, custom

def print_usage():
    sys.stderr.write("Usage:\n")
    sys.stderr.write("  %s [options] %s output-dir\n" % (sys.argv[0], SKOOL_DAZE))
    sys.stderr.write("  %s [options] %s output-dir\n" % (sys.argv[0], BACK_TO_SKOOL))
    sys.stderr.write("\nOptions:\n")
    sys.stderr.write("  -q    Quiet operation\n")
    sys.stderr.write("  -c N  Write files for customisation N (default=0):\n")
    sys.stderr.write("          Skool Daze:\n")
    sys.stderr.write("            N=0: default\n")
    sys.stderr.write("            N=1: Skool Daze Take Too\n")
    sys.stderr.write("            N=2: Ezad Looks\n")
    sys.stderr.write("          Back to Skool:\n")
    sys.stderr.write("            N=0: default\n")
    sys.stderr.write("            N=1: Back to Skool Daze\n")
    sys.exit(1)

###############################################################################
# Begin
###############################################################################
if len(sys.argv) < 3:
    print_usage()

verbose, custom = parse_options(sys.argv[1:-2])
game, odir = sys.argv[-2:]

if game == SKOOL_DAZE:
    ini_maker = SDIniMaker(custom)
elif game == BACK_TO_SKOOL:
    ini_maker = BTSIniMaker(custom)
else:
    print_usage()

if not os.path.isdir(odir):
    os.makedirs(odir)

ini_maker.write_ini_files(odir, verbose)
