#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright 2008-2010 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

import sys
import os.path
from optparse import OptionParser
pyskool_dir = os.path.abspath(os.path.dirname(__file__))
sys.path.insert(0, os.path.join(pyskool_dir, 'pyskool'))
from game import Game

VERSION = "0.5.1"
RELEASE_DATE = "2010-06-21"

names = {}
names['skool_daze.py'] = 'Skool Daze'
names['back_to_skool.py'] = 'Back to Skool'
names['skool_daze_take_too.py'] = 'Skool Daze Take Too'
names['ezad_looks.py'] = 'Ezad Looks'
names['back_to_skool_daze.py'] = 'Back to Skool Daze'
prog = os.path.basename(sys.argv[0].lower())
name = names.get(prog, 'Unknown')
default_ini_dir = os.path.join('ini', prog[:-3])
usage = "%prog [options]"
version = "%s (%s)" % (VERSION, RELEASE_DATE)
synopsis = "Start Pyskool in %s mode" % name
parser = OptionParser(usage=usage, version=version, description=synopsis)
parser.add_option("-s", "--scale", dest="scale",
    help="scale graphics by this factor (1=original Speccy size)")
parser.add_option("-i", "--inidir", dest="inidir",
    help="read ini files from this directory instead of %s" % default_ini_dir)
parser.add_option("-q", "--quick-start", dest="quick_start", action="store_true",
    help="start the game quickly")
parser.add_option("-c", "--cheat", dest="cheat", action="store_true",
    help="enable cheat keys")
parser.add_option("-l", "--load", dest="savefile",
    help="load a saved game from the specified file")
parser.add_option("-r", "--load-last", dest="savedir",
    help="load the most recently saved game in the specified directory")
options, args = parser.parse_args()

scale = int(options.scale) if options.scale and options.scale.isdigit() else None
if options.inidir:
    ini_dir = os.path.abspath(options.inidir)
else:
    ini_dir = os.path.join(pyskool_dir, default_ini_dir)
if not os.path.isdir(ini_dir):
    sys.stderr.write('%s: directory does not exist\n' % ini_dir)
    sys.exit(1)
sav_file = options.savefile
save_dir = options.savedir
if not sav_file and save_dir and os.path.isdir(save_dir):
    sav_files = [f for f in os.listdir(save_dir) if f.endswith('.sav') and os.path.isfile(os.path.join(save_dir, f))]
    if sav_files:
        sav_files.sort()
        sav_file = os.path.abspath(os.path.join(save_dir, sav_files[-1]))
os.chdir(pyskool_dir)
game = Game('pyskool.ini', scale, ini_dir, options.quick_start, options.cheat, VERSION, sav_file)
game.play()
