# -*- coding: utf-8 -*-

# Copyright 2010, 2014 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

from .skoolini import SKOOL_DAZE_TAKE_TOO
from . import skoolbuilder
from .skooltaps import *
from .skoolids import *

SIG_MAP_ROOM_READY = 'MapRoomReady'
SIG_READING_ROOM_READY = 'ReadingRoomReady'
SIG_EXAM_ROOM_READY = 'ExamRoomReady'
SIG_WHITE_ROOM_READY = 'WhiteRoomReady'

SIG_BOY1_READY = 'Boy1Ready'
SIG_BOY1_READY_AGAIN = 'Boy1ReadyAgain'

SIG_SWOT_READY = 'SwotReady'
SIG_WACKER_READY = 'WackerReady'
SIG_ERIC_WAS_TOLD_ABOUT_SWOT = 'EricWasToldAboutSwot'
SIG_SWOT_GRASSED = 'SwotGrassed'

SIG_ERIC_WAS_TOLD_ABOUT_BULLY = 'EricWasToldAboutBully'
SIG_ERIC_HAS_MUMPS = 'EricHasMumps'

SIG_TEARAWAY_READY = 'TearawayReady'
SIG_WACKER_READY_TO_RACE = 'WackerReadyToRace'
SIG_ERIC_WAS_TOLD_ABOUT_TEARAWAY = 'EricWasToldAboutTearaway'

CL_BIG_WINDOW = 'BigWindow'
CL_BULLY_HAS_MUMPS_BOY = 'BullyHasMumps-Boy'
CL_BULLY_HAS_MUMPS_BULLY = 'MumpsWalkabout-Bully'
CL_BULLY_HAS_MUMPS_TEACHER = 'YouHaveMumps-Teacher'
CL_DINNER_BOY = 'Dinner-Boy'
CL_DINNER_BULLY = 'Dinner-Bully'
CL_DINNER_DUTY = 'DinnerDuty'
CL_DINNER_TEARAWAY = 'Dinner-Tearaway'
CL_EXAM_ROOM_BOY = 'ExamRoom-Boy'
CL_EXAM_ROOM_BULLY = 'ExamRoom-Bully'
CL_EXAM_ROOM_SWOT = 'ExamRoom-Swot'
CL_EXAM_ROOM_TEACHER = 'ExamRoom-Teacher'
CL_EXAM_ROOM_TEARAWAY = 'ExamRoom-Tearaway'
CL_FIRE_ESCAPE = 'FireEscape'
CL_GRASS_ON_ERIC_BOY = 'GrassOnEric-Boy'
CL_GRASS_ON_ERIC_SWOT = 'GrassOnEric-Swot'
CL_GRASS_ON_ERIC_WACKER = 'GrassOnEric-Wacker'
CL_GYM = 'Gym'
CL_HEADS_STUDY = 'HeadsStudy'
CL_MAP_ROOM_BOY = 'MapRoom-Boy'
CL_MAP_ROOM_BULLY = 'MapRoom-Bully'
CL_MAP_ROOM_SWOT = 'MapRoom-Swot'
CL_MAP_ROOM_TEACHER = 'MapRoom-Teacher'
CL_MAP_ROOM_TEARAWAY = 'MapRoom-Tearaway'
CL_PEA_SHOOTER_BOY = 'HiddenPeaShooter-Boy'
CL_PEA_SHOOTER_TEARAWAY = 'HiddenPeaShooter-Tearaway'
CL_PEA_SHOOTER_WACKER = 'HiddenPeaShooter-Wacker'
CL_RANDOM_WALKABOUT = 'RandomWalkabout'
CL_READING_ROOM_BOY = 'ReadingRoom-Boy'
CL_READING_ROOM_BULLY = 'ReadingRoom-Bully'
CL_READING_ROOM_SWOT = 'ReadingRoom-Swot'
CL_READING_ROOM_TEACHER = 'ReadingRoom-Teacher'
CL_READING_ROOM_TEARAWAY = 'ReadingRoom-Tearaway'
CL_REVISION_LIBRARY_BOY = 'RevisionLibrary-Boy'
CL_REVISION_LIBRARY_BULLY = 'RevisionLibrary-Bully'
CL_REVISION_LIBRARY_TEARAWAY = 'RevisionLibrary-Tearaway'
CL_STAFF_ROOM = 'StaffRoom'
CL_STAMPEDE_FOLLOWER = 'Stampede-Follower'
CL_STAMPEDE_LEADER = 'Stampede-Leader'
CL_WALKABOUT_BULLY = 'Walkabout-Bully'
CL_WALKABOUT_TEACHER = 'Walkabout-Teacher'
CL_WALKABOUT_TEARAWAY = 'Walkabout-Tearaway'
CL_WHITE_ROOM_BOY = 'WhiteRoom-Boy'
CL_WHITE_ROOM_BULLY = 'WhiteRoom-Bully'
CL_WHITE_ROOM_SWOT = 'WhiteRoom-Swot'
CL_WHITE_ROOM_TEACHER = 'WhiteRoom-Teacher'
CL_WHITE_ROOM_TEARAWAY = 'WhiteRoom-Tearaway'
CL_WRITE_ON_BOARDS = 'WriteOnBoards-Tearaway'

class SDTapMaker:
    def __init__(self, custom):
        self.custom = custom

    def get_taps(self):
        taps = []

        tap = CommandList(CL_MAP_ROOM_TEACHER)
        tap.add_command(GO_TO, LOC_FIRE_ESCAPE)
        tap.add_command(GO_TO, LOC_MAP_ROOM_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_MAP_ROOM_READY)
        tap.add_command(GO_TO, LOC_MAP_ROOM_MAP)
        tap.add_command(GO_TO, LOC_MAP_ROOM_MAP_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_READING_ROOM_TEACHER)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY)
        tap.add_command(GO_TO, LOC_READING_ROOM_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_READING_ROOM_READY)
        tap.add_command(GO_TO, LOC_READING_ROOM)
        tap.add_command(GO_TO, LOC_READING_ROOM_BOARD_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_EXAM_ROOM_TEACHER)
        tap.add_command(GO_TO, LOC_FIRE_ESCAPE)
        tap.add_command(GO_TO, LOC_EXAM_ROOM_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_EXAM_ROOM_READY)
        tap.add_command(GO_TO, LOC_EXAM_ROOM_BOARD_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_WHITE_ROOM_TEACHER)
        tap.add_command(GO_TO, LOC_STAFF_ROOM)
        tap.add_command(GO_TO, LOC_WHITE_ROOM_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_WHITE_ROOM_READY)
        tap.add_command(GO_TO, LOC_WHITE_ROOM)
        tap.add_command(GO_TO, LOC_WHITE_ROOM_BOARD_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_MAP_ROOM_BOY)
        tap.add_command(GO_TO, LOC_MAP_ROOM_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_MAP_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_MAP_ROOM_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_MAP_ROOM_0)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_MAP_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_MAP_ROOM_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_MAP_ROOM_2)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_MAP_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_MAP_ROOM_SWOT)
        tap.add_command(GO_TO, LOC_MAP_ROOM_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_MAP_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIGNAL, SIG_SWOT_READY_FOR_LESSON)
        tap.add_command(GRASS_AND_ANSWER_QUESTIONS)
        taps.append(tap)

        tap = CommandList(CL_READING_ROOM_BOY)
        tap.add_command(GO_TO, LOC_READING_ROOM_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_READING_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_READING_ROOM_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_READING_ROOM_BOARD)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_READING_ROOM_READY)
        tap.add_command(GO_TO, LOC_READING_ROOM_2)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_READING_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_READING_ROOM_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_READING_ROOM_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_READING_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_READING_ROOM_SWOT)
        tap.add_command(GO_TO, LOC_READING_ROOM_2)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_READING_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIGNAL, SIG_SWOT_READY_FOR_LESSON)
        tap.add_command(GRASS_AND_ANSWER_QUESTIONS)
        taps.append(tap)

        tap = CommandList(CL_EXAM_ROOM_BOY)
        tap.add_command(GO_TO, LOC_EXAM_ROOM_3)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_EXAM_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_EXAM_ROOM_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_EXAM_ROOM_BOARD)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_EXAM_ROOM_READY)
        tap.add_command(GO_TO, LOC_EXAM_ROOM_2)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_EXAM_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_EXAM_ROOM_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_EXAM_ROOM_1)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_EXAM_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_EXAM_ROOM_SWOT)
        tap.add_command(GO_TO, LOC_EXAM_ROOM_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_EXAM_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIGNAL, SIG_SWOT_READY_FOR_LESSON)
        tap.add_command(GRASS_AND_ANSWER_QUESTIONS)
        taps.append(tap)

        tap = CommandList(CL_WHITE_ROOM_BOY)
        tap.add_command(GO_TO, LOC_WHITE_ROOM_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_WHITE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_WHITE_ROOM_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_WHITE_ROOM_BOARD)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_WHITE_ROOM_READY)
        tap.add_command(GO_TO, LOC_WHITE_ROOM_2)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_WHITE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_WHITE_ROOM_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_WHITE_ROOM_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_WHITE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_WHITE_ROOM_SWOT)
        tap.add_command(GO_TO, LOC_WHITE_ROOM_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_WHITE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIGNAL, SIG_SWOT_READY_FOR_LESSON)
        tap.add_command(GRASS_AND_ANSWER_QUESTIONS)
        taps.append(tap)

        tap = CommandList(CL_DINNER_BOY)
        tap.add_command(GO_TO, LOC_DINNER_HALL_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_DINNER_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_DINNER_HALL_0)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_DINNER_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_DINNER_HALL_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_REVISION_LIBRARY_BOY)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_REVISION_LIBRARY_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY_0)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_REVISION_LIBRARY_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(WALK_AROUND, 10)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_DINNER_DUTY)
        tap.add_command(GO_TO, LOC_DINNER_HALL_FAR_END)
        tap.add_command(GO_TO, LOC_DINNER_HALL_NEAR_END)
        tap.add_command(START_DINNER_IF_READY)
        tap.add_command(SET_RESTART_POINT)
        tap.add_command(GO_TO, LOC_DINNER_HALL_FAR_END)
        tap.add_command(FIND_ERIC_IF_MISSING)
        tap.add_command(GO_TO, LOC_DINNER_HALL_NEAR_END)
        tap.add_command(FIND_ERIC_IF_MISSING)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_HEADS_STUDY)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_STAFF_ROOM)
        tap.add_command(GO_TO, LOC_STAFF_ROOM_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT_TEACHER)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_WINDOW)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_WRITE_ON_BOARDS)
        tap.add_command(GO_TO, LOC_EXAM_ROOM_BOARD)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_END_OF_LESSON)
        tap.add_command(GO_TO, LOC_WHITE_ROOM_BOARD)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_END_OF_LESSON)
        tap.add_command(GO_TO, LOC_READING_ROOM_BOARD)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_END_OF_LESSON)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(WALK_AROUND, 10)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(WALK_AROUND, 10)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_RANDOM_WALKABOUT)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(WALK_AROUND, 10)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_FIRE_ESCAPE)
        tap.add_command(GO_TO, LOC_FIRE_ESCAPE_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_GYM)
        tap.add_command(GO_TO, LOC_GYM)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_BIG_WINDOW)
        tap.add_command(GO_TO, LOC_BIG_WINDOW)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_STAMPEDE_LEADER)
        tap.add_command(WALK_AROUND, 10)
        tap.add_command(SIGNAL, SIG_BOY1_READY)
        tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(UNSIGNAL, SIG_BOY1_READY)
        tap.add_command(WALK_AROUND, 10)
        tap.add_command(SIGNAL, SIG_BOY1_READY_AGAIN)
        tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(UNSIGNAL, SIG_BOY1_READY_AGAIN)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_STAMPEDE_FOLLOWER)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_BOY1_READY)
        tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
        tap.add_command(FOLLOW, BOY01)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_BOY1_READY_AGAIN)
        tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
        tap.add_command(FOLLOW, BOY01)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_GRASS_ON_ERIC_BOY)
        tap.add_command(GO_TO, LOC_GYM)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_SWOT_READY)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_WACKER_READY)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC_AND_WAIT, "$%s is going to tell $%s what you're up to. You must stop him getting to his study this break         Press 'U' if you understood" % (SWOT, WACKER))
        tap.add_command(SIGNAL, SIG_ERIC_WAS_TOLD_ABOUT_SWOT)
        tap.add_command(SET_CLOCK, 1500)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_BULLY_HAS_MUMPS_BOY)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC_AND_WAIT, "Don't let $%s touch you this playtime - He's got mumps         Press 'U' if you understood" % BULLY)
        tap.add_command(SIGNAL, SIG_ERIC_WAS_TOLD_ABOUT_BULLY)
        tap.add_command(SET_CLOCK, 1500)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_GRASS_ON_ERIC_SWOT)
        tap.add_command(GO_TO, LOC_FIRE_ESCAPE_0)
        tap.add_command(SIGNAL, SIG_SWOT_READY)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_ERIC_WAS_TOLD_ABOUT_SWOT)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_DESK)
        tap.add_command(SIGNAL, SIG_SWOT_GRASSED)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_GRASS_ON_ERIC_WACKER)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_0)
        tap.add_command(SIGNAL, SIG_WACKER_READY)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_SWOT_GRASSED)
        tap.add_command(SET_CONTROLLING_COMMAND, WALK_FAST)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC, 'TAKE 2000 LINES YOU NASTY BOY')
        tap.add_command(ADD_LINES, 2000)
        tap.add_command(SET_CLOCK, 100)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_PEA_SHOOTER_TEARAWAY)
        tap.add_command(GO_TO, LOC_PEA_SHOOTER_RACE_1)
        tap.add_command(SIGNAL, SIG_TEARAWAY_READY)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_ERIC_WAS_TOLD_ABOUT_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_FIRE_ESCAPE_0)
        tap.add_command(UNSIGNAL, SIG_TEARAWAY_READY)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_PEA_SHOOTER_WACKER)
        tap.add_command(GO_TO, LOC_PEA_SHOOTER_RACE_0)
        tap.add_command(SIGNAL, SIG_WACKER_READY_TO_RACE)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_ERIC_WAS_TOLD_ABOUT_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, WALK_FAST)
        tap.add_command(GO_TO, LOC_FIRE_ESCAPE_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_TEARAWAY_READY)
        tap.add_command(SET_CONTROLLING_COMMAND, WALK_FAST)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC, 'TAKE 2000 LINES YOU NASTY BOY')
        tap.add_command(ADD_LINES, 2000)
        tap.add_command(SET_CLOCK, 100)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_BULLY_HAS_MUMPS_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, CHECK_IF_TOUCHING_ERIC, SIG_ERIC_WAS_TOLD_ABOUT_BULLY, SIG_ERIC_HAS_MUMPS)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_BULLY_HAS_MUMPS_TEACHER)
        tap.add_command(GO_TO, LOC_STAFF_ROOM_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_ERIC_HAS_MUMPS)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC, 'You have mumps $%s. Go home at once. This game is over' % HERO)
        tap.add_command(END_GAME)
        taps.append(tap)

        tap = CommandList(CL_PEA_SHOOTER_BOY)
        tap.add_command(GO_TO, LOC_GYM)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_TEARAWAY_READY)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_WACKER_READY_TO_RACE)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC_AND_WAIT, "$%s has hidden a pea-shooter with your name on it on the fire-escape. If $%s gets there before $%s you'll get lines         Press 'U' if you understood" % (TEARAWAY, WACKER, TEARAWAY))
        tap.add_command(SIGNAL, SIG_ERIC_WAS_TOLD_ABOUT_TEARAWAY)
        tap.add_command(SET_CLOCK, 1500)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_PELLET)
        tap.add_command(MOVE_PELLET)
        taps.append(tap)

        tap = CommandList(CL_EXPEL_ERIC_TOO_MANY_LINES)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC, "YOU HAVE OVER 10000 LINES TO WRITE $%s. DON'T COME BACK TO SCHOOL TILL YOU HAVE DONE THEM ALL. . . ." % HERO)
        tap.add_command(END_GAME)
        taps.append(tap)

        return taps

    def get_lessons(self):
        lessons = []

        lesson = Lesson(LSN_DINNER_WITHIT, '%s%s' % (skoolbuilder.HIDE_TEACHER_MARKER, WITHIT), DINNER_HALL)
        lesson.add_entry(BOY01, CL_DINNER_BOY)
        lesson.add_entry(BOY02, CL_DINNER_BOY)
        lesson.add_entry(BOY03, CL_DINNER_BOY)
        lesson.add_entry(BOY04, CL_DINNER_BOY)
        lesson.add_entry(BOY05, CL_DINNER_BOY)
        lesson.add_entry(BOY06, CL_DINNER_BOY)
        lesson.add_entry(BOY07, CL_DINNER_BOY)
        lesson.add_entry(BOY08, CL_DINNER_BOY)
        lesson.add_entry(BOY09, CL_DINNER_BOY)
        lesson.add_entry(BOY10, CL_DINNER_BOY)
        lesson.add_entry(BOY11, CL_DINNER_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(ROCKITT, CL_STAFF_ROOM)
        lesson.add_entry(WITHIT, CL_DINNER_DUTY)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_DINNER_TEARAWAY)
        lesson.add_entry(BULLY, CL_DINNER_BULLY)
        lesson.add_entry(SWOT, CL_DINNER_BOY)
        lessons.append(lesson)

        lesson = Lesson(LSN_DINNER_WACKER, '%s%s' % (skoolbuilder.HIDE_TEACHER_MARKER, WACKER), DINNER_HALL)
        lesson.add_entry(BOY01, CL_DINNER_BOY)
        lesson.add_entry(BOY02, CL_DINNER_BOY)
        lesson.add_entry(BOY03, CL_DINNER_BOY)
        lesson.add_entry(BOY04, CL_DINNER_BOY)
        lesson.add_entry(BOY05, CL_DINNER_BOY)
        lesson.add_entry(BOY06, CL_DINNER_BOY)
        lesson.add_entry(BOY07, CL_DINNER_BOY)
        lesson.add_entry(BOY08, CL_DINNER_BOY)
        lesson.add_entry(BOY09, CL_DINNER_BOY)
        lesson.add_entry(BOY10, CL_DINNER_BOY)
        lesson.add_entry(BOY11, CL_DINNER_BOY)
        lesson.add_entry(WACKER, CL_DINNER_DUTY)
        lesson.add_entry(ROCKITT, CL_STAFF_ROOM)
        lesson.add_entry(WITHIT, CL_FIRE_ESCAPE)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_DINNER_TEARAWAY)
        lesson.add_entry(BULLY, CL_DINNER_BULLY)
        lesson.add_entry(SWOT, CL_DINNER_BOY)
        lessons.append(lesson)

        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson = Lesson(LSN_TAKE_WHITE_ROOM, TAKE, WHITE_ROOM)
            lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY03, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
            lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY11, CL_WHITE_ROOM_BOY)
            lesson.add_entry(WACKER, CL_EXAM_ROOM_TEACHER)
            lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
            lesson.add_entry(WITHIT, CL_READING_ROOM_TEACHER)
            lesson.add_entry(CREAK, CL_STAFF_ROOM)
            lesson.add_entry(TAKE, CL_WHITE_ROOM_TEACHER)
            lesson.add_entry(TEARAWAY, CL_WHITE_ROOM_TEARAWAY)
            lesson.add_entry(BULLY, CL_EXAM_ROOM_BULLY)
            lesson.add_entry(SWOT, CL_WHITE_ROOM_SWOT)
            lessons.append(lesson)

            lesson = Lesson(LSN_TAKE_READING_ROOM, TAKE, READING_ROOM)
            lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY03, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY04, CL_WHITE_ROOM_BOY)
            lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
            lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY11, CL_WHITE_ROOM_BOY)
            lesson.add_entry(WACKER, CL_EXAM_ROOM_TEACHER)
            lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
            lesson.add_entry(WITHIT, CL_WHITE_ROOM_TEACHER)
            lesson.add_entry(CREAK, CL_STAFF_ROOM)
            lesson.add_entry(TAKE, CL_READING_ROOM_TEACHER)
            lesson.add_entry(TEARAWAY, CL_WHITE_ROOM_TEARAWAY)
            lesson.add_entry(BULLY, CL_EXAM_ROOM_BULLY)
            lesson.add_entry(SWOT, CL_READING_ROOM_SWOT)
            lessons.append(lesson)

            lesson = Lesson(LSN_TAKE_MAP_ROOM, TAKE, MAP_ROOM)
            lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY03, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY05, CL_MAP_ROOM_BOY)
            lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY11, CL_MAP_ROOM_BOY)
            lesson.add_entry(WACKER, CL_EXAM_ROOM_TEACHER)
            lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
            lesson.add_entry(WITHIT, CL_READING_ROOM_TEACHER)
            lesson.add_entry(CREAK, CL_STAFF_ROOM)
            lesson.add_entry(TAKE, CL_MAP_ROOM_TEACHER)
            lesson.add_entry(TEARAWAY, CL_READING_ROOM_TEARAWAY)
            lesson.add_entry(BULLY, CL_MAP_ROOM_BULLY)
            lesson.add_entry(SWOT, CL_MAP_ROOM_SWOT)
            lessons.append(lesson)

            lesson = Lesson(LSN_TAKE_EXAM_ROOM, TAKE, EXAM_ROOM)
            lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY03, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
            lesson.add_entry(BOY05, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
            lesson.add_entry(BOY11, CL_READING_ROOM_BOY)
            lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
            lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
            lesson.add_entry(WITHIT, CL_READING_ROOM_TEACHER)
            lesson.add_entry(CREAK, CL_STAFF_ROOM)
            lesson.add_entry(TAKE, CL_EXAM_ROOM_TEACHER)
            lesson.add_entry(TEARAWAY, CL_EXAM_ROOM_TEARAWAY)
            lesson.add_entry(BULLY, CL_EXAM_ROOM_BULLY)
            lesson.add_entry(SWOT, CL_EXAM_ROOM_SWOT)
            lessons.append(lesson)

        lesson = Lesson(LSN_WACKER_EXAM_ROOM, WACKER, EXAM_ROOM)
        lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY03, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY05, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY11, CL_EXAM_ROOM_BOY)
        lesson.add_entry(WACKER, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WITHIT, CL_READING_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_EXAM_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_EXAM_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_EXAM_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_ROCKITT_EXAM_ROOM, ROCKITT, EXAM_ROOM)
        lesson.add_entry(BOY01, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY02, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY03, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY04, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY11, CL_EXAM_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_WALKABOUT_TEACHER)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_EXAM_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_EXAM_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_EXAM_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_REVISION_LIBRARY_1, REVISION_LIBRARY)
        lesson.add_entry(BOY01, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY03, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY11, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(WACKER, CL_READING_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_BIG_WINDOW)
        lesson.add_entry(CREAK, CL_WHITE_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_REVISION_LIBRARY_TEARAWAY)
        lesson.add_entry(BULLY, CL_WHITE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_REVISION_LIBRARY_BOY)
        lessons.append(lesson)

        lesson = Lesson(LSN_REVISION_LIBRARY_2, REVISION_LIBRARY)
        lesson.add_entry(BOY01, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY02, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY03, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY05, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY06, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY07, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY08, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY09, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY10, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY11, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_STAFF_ROOM)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_READING_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_MAP_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_REVISION_LIBRARY_BULLY)
        lesson.add_entry(SWOT, CL_REVISION_LIBRARY_BOY)
        lessons.append(lesson)

        lesson = Lesson(LSN_REVISION_LIBRARY_3, REVISION_LIBRARY)
        lesson.add_entry(BOY01, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY02, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY04, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY08, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY09, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY10, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY11, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_WHITE_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_REVISION_LIBRARY_TEARAWAY)
        lesson.add_entry(BULLY, CL_REVISION_LIBRARY_BULLY)
        lesson.add_entry(SWOT, CL_REVISION_LIBRARY_BOY)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_MAP_ROOM_1, WITHIT, MAP_ROOM)
        lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY02, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY04, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY05, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY06, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY08, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY11, CL_MAP_ROOM_BOY)
        lesson.add_entry(WACKER, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_WHITE_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_READING_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_EXAM_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_MAP_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_MAP_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_WACKER_READING_ROOM, WACKER, READING_ROOM)
        lesson.add_entry(BOY01, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY03, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY04, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY05, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY07, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY09, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY10, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY11, CL_READING_ROOM_BOY)
        lesson.add_entry(WACKER, CL_READING_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_WHITE_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_READING_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_WHITE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_READING_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_ROCKITT_READING_ROOM, ROCKITT, READING_ROOM)
        lesson.add_entry(BOY01, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY02, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY03, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY04, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY05, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY06, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY09, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY10, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY11, CL_READING_ROOM_BOY)
        lesson.add_entry(WACKER, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_READING_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_WHITE_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_READING_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_READING_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_READING_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_CREAK_READING_ROOM_1, CREAK, READING_ROOM)
        lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY02, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY03, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY04, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY07, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY09, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY10, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY11, CL_READING_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WHITE_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_READING_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_READING_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_READING_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_READING_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_CREAK_WHITE_ROOM, CREAK, WHITE_ROOM)
        lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY02, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY03, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY05, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY07, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY08, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY10, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY11, CL_WHITE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_READING_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_WHITE_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WHITE_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_WHITE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_WHITE_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_WACKER_WHITE_ROOM, WACKER, WHITE_ROOM)
        lesson.add_entry(BOY01, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY03, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY05, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY06, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY07, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY11, CL_WHITE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WHITE_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_READING_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_REVISION_LIBRARY_TEARAWAY)
        lesson.add_entry(BULLY, CL_WHITE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_WHITE_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_WHITE_ROOM, WITHIT, WHITE_ROOM)
        lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY02, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY04, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY05, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY06, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY08, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY09, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY11, CL_WHITE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_WHITE_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_READING_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_REVISION_LIBRARY_TEARAWAY)
        lesson.add_entry(BULLY, CL_REVISION_LIBRARY_BULLY)
        lesson.add_entry(SWOT, CL_WHITE_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_ROCKITT_WHITE_ROOM_1, ROCKITT, WHITE_ROOM)
        lesson.add_entry(BOY01, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY02, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY03, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY04, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY07, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY08, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY10, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY11, CL_WHITE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_WHITE_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_READING_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WHITE_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_REVISION_LIBRARY_BULLY)
        lesson.add_entry(SWOT, CL_WHITE_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_WACKER_MAP_ROOM, WACKER, MAP_ROOM)
        lesson.add_entry(BOY01, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY02, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY04, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY05, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY07, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY09, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY11, CL_MAP_ROOM_BOY)
        lesson.add_entry(WACKER, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_READING_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_WHITE_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_EXAM_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_MAP_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_MAP_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_MAP_ROOM_2, WITHIT, MAP_ROOM)
        lesson.add_entry(BOY01, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY02, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY03, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY04, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY09, CL_READING_ROOM_BOY)
        lesson.add_entry(BOY10, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY11, CL_MAP_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_READING_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_WHITE_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_MAP_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_MAP_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_MAP_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_ROCKITT_WHITE_ROOM_2, ROCKITT, WHITE_ROOM)
        lesson.add_entry(BOY01, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY02, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY03, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY04, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY05, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY06, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY07, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY08, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY09, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY10, CL_EXAM_ROOM_BOY)
        lesson.add_entry(BOY11, CL_WHITE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_EXAM_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_WHITE_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WHITE_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_WHITE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_WHITE_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_CREAK_READING_ROOM_2, CREAK, READING_ROOM)
        lesson.add_entry(BOY01, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY02, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY03, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY04, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY05, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY07, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY09, CL_MAP_ROOM_BOY)
        lesson.add_entry(BOY10, CL_WHITE_ROOM_BOY)
        lesson.add_entry(BOY11, CL_READING_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_WHITE_ROOM_TEACHER)
        lesson.add_entry(WITHIT, CL_MAP_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_READING_ROOM_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_READING_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_READING_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_READING_ROOM_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_MUMPS, PLAYTIME)
        lesson.add_entry(BOY01, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY02, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY03, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY04, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY05, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY06, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY07, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY08, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY09, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY10, CL_BULLY_HAS_MUMPS_BOY)
        lesson.add_entry(BOY11, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_BULLY_HAS_MUMPS_TEACHER)
        lesson.add_entry(WITHIT, CL_WALKABOUT_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BULLY, CL_BULLY_HAS_MUMPS_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_SWOT_GRASS, PLAYTIME)
        lesson.add_entry(BOY01, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY02, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY03, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY04, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY05, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY06, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY07, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY08, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY09, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY10, CL_GRASS_ON_ERIC_BOY)
        lesson.add_entry(BOY11, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WACKER, CL_GRASS_ON_ERIC_WACKER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT_TEACHER)
        lesson.add_entry(WITHIT, CL_WALKABOUT_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BULLY, CL_RANDOM_WALKABOUT)
        lesson.add_entry(SWOT, CL_GRASS_ON_ERIC_SWOT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_PEA_SHOOTER, PLAYTIME)
        lesson.add_entry(BOY01, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY02, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY03, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY04, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY05, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY06, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY07, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY08, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY09, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY10, CL_PEA_SHOOTER_BOY)
        lesson.add_entry(BOY11, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WACKER, CL_PEA_SHOOTER_WACKER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT_TEACHER)
        lesson.add_entry(WITHIT, CL_WALKABOUT_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT_TEACHER)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_PEA_SHOOTER_TEARAWAY)
        lesson.add_entry(BULLY, CL_RANDOM_WALKABOUT)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_1, PLAYTIME)
        lesson.add_entry(BOY01, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY02, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY03, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY04, CL_GYM)
        lesson.add_entry(BOY05, CL_GYM)
        lesson.add_entry(BOY06, CL_GYM)
        lesson.add_entry(BOY07, CL_BIG_WINDOW)
        lesson.add_entry(BOY08, CL_BIG_WINDOW)
        lesson.add_entry(BOY09, CL_BIG_WINDOW)
        lesson.add_entry(BOY10, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY11, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT_TEACHER)
        lesson.add_entry(WITHIT, CL_WALKABOUT_TEACHER)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WRITE_ON_BOARDS)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_2, PLAYTIME)
        lesson.add_entry(BOY01, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY02, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY03, CL_GYM)
        lesson.add_entry(BOY04, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY05, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY06, CL_BIG_WINDOW)
        lesson.add_entry(BOY07, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY08, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY09, CL_GYM)
        lesson.add_entry(BOY10, CL_GYM)
        lesson.add_entry(BOY11, CL_BIG_WINDOW)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(ROCKITT, CL_STAFF_ROOM)
        lesson.add_entry(WITHIT, CL_STAFF_ROOM)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_3, PLAYTIME)
        lesson.add_entry(BOY01, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY02, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY03, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY04, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY05, CL_BIG_WINDOW)
        lesson.add_entry(BOY06, CL_GYM)
        lesson.add_entry(BOY07, CL_GYM)
        lesson.add_entry(BOY08, CL_BIG_WINDOW)
        lesson.add_entry(BOY09, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY10, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY11, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WITHIT, CL_STAFF_ROOM)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WRITE_ON_BOARDS)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_4, PLAYTIME)
        lesson.add_entry(BOY01, CL_BIG_WINDOW)
        lesson.add_entry(BOY02, CL_BIG_WINDOW)
        lesson.add_entry(BOY03, CL_BIG_WINDOW)
        lesson.add_entry(BOY04, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY05, CL_GYM)
        lesson.add_entry(BOY06, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY07, CL_GYM)
        lesson.add_entry(BOY08, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY09, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY10, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY11, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_STAFF_ROOM)
        lesson.add_entry(WITHIT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WRITE_ON_BOARDS)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_5, PLAYTIME)
        lesson.add_entry(BOY01, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY02, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY03, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY04, CL_GYM)
        lesson.add_entry(BOY05, CL_GYM)
        lesson.add_entry(BOY06, CL_BIG_WINDOW)
        lesson.add_entry(BOY07, CL_BIG_WINDOW)
        lesson.add_entry(BOY08, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY09, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY10, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY11, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WITHIT, CL_STAFF_ROOM)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WRITE_ON_BOARDS)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_6, PLAYTIME)
        lesson.add_entry(BOY01, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY02, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY03, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY04, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY05, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY06, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY07, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY08, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY09, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY10, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY11, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WITHIT, CL_STAFF_ROOM)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_STAMPEDE_1, PLAYTIME)
        lesson.add_entry(BOY01, CL_STAMPEDE_LEADER)
        lesson.add_entry(BOY02, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY03, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY04, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY05, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY06, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY07, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY08, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY09, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY10, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY11, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WITHIT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(CREAK, CL_RANDOM_WALKABOUT)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_STAMPEDE_2, PLAYTIME)
        lesson.add_entry(BOY01, CL_STAMPEDE_LEADER)
        lesson.add_entry(BOY02, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY03, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY04, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY05, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY06, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY07, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY08, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY09, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY10, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(BOY11, CL_STAMPEDE_FOLLOWER)
        lesson.add_entry(WACKER, CL_RANDOM_WALKABOUT)
        lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WITHIT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(CREAK, CL_RANDOM_WALKABOUT)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_7, PLAYTIME)
        lesson.add_entry(BOY01, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY02, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY03, CL_GYM)
        lesson.add_entry(BOY04, CL_BIG_WINDOW)
        lesson.add_entry(BOY05, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY06, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY07, CL_GYM)
        lesson.add_entry(BOY08, CL_BIG_WINDOW)
        lesson.add_entry(BOY09, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY10, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY11, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(WACKER, CL_STAFF_ROOM)
        lesson.add_entry(ROCKITT, CL_STAFF_ROOM)
        lesson.add_entry(WITHIT, CL_STAFF_ROOM)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WRITE_ON_BOARDS)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_8, PLAYTIME)
        lesson.add_entry(BOY01, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY02, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY03, CL_RANDOM_WALKABOUT)
        lesson.add_entry(BOY04, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY05, CL_GYM)
        lesson.add_entry(BOY06, CL_BIG_WINDOW)
        lesson.add_entry(BOY07, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY08, CL_FIRE_ESCAPE)
        lesson.add_entry(BOY09, CL_GYM)
        lesson.add_entry(BOY10, CL_BIG_WINDOW)
        lesson.add_entry(BOY11, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WACKER, CL_WALKABOUT_TEACHER)
        lesson.add_entry(ROCKITT, CL_RANDOM_WALKABOUT)
        lesson.add_entry(WITHIT, CL_STAFF_ROOM)
        lesson.add_entry(CREAK, CL_STAFF_ROOM)
        if self.custom == SKOOL_DAZE_TAKE_TOO:
            lesson.add_entry(TAKE, CL_STAFF_ROOM)
        lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_RANDOM_WALKABOUT)
        lessons.append(lesson)

        return lessons
